// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Processutil.pas' rev: 10.00

#ifndef ProcessutilHPP
#define ProcessutilHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Pipeutil.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Syncobjs.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Processutil
{
//-- type declarations -------------------------------------------------------
typedef void __fastcall (__closure *TEnumProcessesEvent)(int ProcessId, AnsiString ProcessName);

#pragma option push -b-
enum TProcessVisibility { pvHide, pvShow = 5 };
#pragma option pop

class DELPHICLASS TConsoleProcess;
class PASCALIMPLEMENTATION TConsoleProcess : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	AnsiString FCommandLine;
	AnsiString FExeFileName;
	AnsiString FWorkingDir;
	Classes::TStrings* FOutput;
	Classes::TStrings* FErrors;
	Classes::TStrings* FEnvList;
	unsigned FExitCode;
	TProcessVisibility FVisibility;
	bool FDoTimeOut;
	int FTimeOut;
	Classes::TStrings* __fastcall ReadEnvList(void);
	AnsiString __fastcall TranslateEnvList(Classes::TStrings* EnvList);
	
protected:
	void __fastcall DoReportFatalError(const AnsiString ErrMsg);
	virtual void __fastcall ReportFatalError(const AnsiString ErrMsg);
	virtual void __fastcall Startup(Windows::_STARTUPINFOA &StartupInfo, _PROCESS_INFORMATION &ProcessInfo, Pipeutil::TPipe* &InPipe, Pipeutil::TPipe* &OutPipe, Pipeutil::TPipe* &ErrorPipe);
	virtual bool __fastcall Execute(Windows::_STARTUPINFOA &StartupInfo, _PROCESS_INFORMATION &ProcessInfo);
	virtual void __fastcall Running(Windows::_STARTUPINFOA &StartupInfo, _PROCESS_INFORMATION &ProcessInfo, Pipeutil::TPipe* &InPipe, Pipeutil::TPipe* &OutPipe, Pipeutil::TPipe* &ErrorPipe);
	virtual void __fastcall Cleanup(Windows::_STARTUPINFOA &StartupInfo, _PROCESS_INFORMATION &ProcessInfo, Pipeutil::TPipe* &InPipe, Pipeutil::TPipe* &OutPipe, Pipeutil::TPipe* &ErrorPipe);
	virtual void __fastcall SetExeFileName(AnsiString Value);
	virtual void __fastcall SetCommandLine(AnsiString Value);
	virtual void __fastcall SetWorkingDir(AnsiString Value);
	virtual void __fastcall SetExitCode(unsigned Value);
	virtual Classes::TStrings* __fastcall GetOutput(void);
	virtual void __fastcall SetOutput(Classes::TStrings* Value);
	virtual Classes::TStrings* __fastcall GetErrors(void);
	virtual void __fastcall SetErrors(Classes::TStrings* Value);
	virtual Classes::TStrings* __fastcall GetEnvList(void);
	virtual void __fastcall SetTimeOut(int Value);
	
public:
	__fastcall TConsoleProcess(void);
	__fastcall virtual ~TConsoleProcess(void);
	virtual void __fastcall Run(void);
	__property AnsiString ExeFileName = {read=FExeFileName, write=SetExeFileName};
	__property AnsiString CommandLine = {read=FCommandLine, write=SetCommandLine};
	__property AnsiString WorkingDir = {read=FWorkingDir, write=SetWorkingDir};
	__property unsigned ExitCode = {read=FExitCode, write=SetExitCode, nodefault};
	__property Classes::TStrings* Output = {read=GetOutput, write=SetOutput};
	__property Classes::TStrings* Errors = {read=GetErrors, write=SetErrors};
	__property Classes::TStrings* EnvList = {read=GetEnvList};
	__property int TimeOut = {read=FTimeOut, write=SetTimeOut, nodefault};
	__property TProcessVisibility Visibility = {read=FVisibility, write=FVisibility, nodefault};
};


typedef void __fastcall (__closure *TListChanged)(System::TObject* Sender, const Classes::TStringList* List, int Before, int After);

class DELPHICLASS TReportProcess;
class PASCALIMPLEMENTATION TReportProcess : public TConsoleProcess 
{
	typedef TConsoleProcess inherited;
	
protected:
	TListChanged FOnOutputChanged;
	TListChanged FOnErrorChanged;
	virtual bool __fastcall CancelProcess(void);
	virtual void __fastcall Running(Windows::_STARTUPINFOA &StartupInfo, _PROCESS_INFORMATION &ProcessInfo, Pipeutil::TPipe* &InPipe, Pipeutil::TPipe* &OutPipe, Pipeutil::TPipe* &ErrorPipe);
	virtual void __fastcall SetOnOutputChanged(TListChanged Value);
	virtual void __fastcall SetOnErrorChanged(TListChanged Value);
	
public:
	__property TListChanged OnOutChanged = {read=FOnOutputChanged, write=SetOnOutputChanged};
	__property TListChanged OnErrorChanged = {read=FOnErrorChanged, write=SetOnErrorChanged};
public:
	#pragma option push -w-inl
	/* TConsoleProcess.Create */ inline __fastcall TReportProcess(void) : TConsoleProcess() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TConsoleProcess.Destroy */ inline __fastcall virtual ~TReportProcess(void) { }
	#pragma option pop
	
};


class DELPHICLASS TMonitorProcess;
class PASCALIMPLEMENTATION TMonitorProcess : public TReportProcess 
{
	typedef TReportProcess inherited;
	
private:
	Classes::TNotifyEvent FOnTerminate;
	Classes::TThread* FMonitor;
	bool FWatch;
	Syncobjs::TCriticalSection* FOnOutputLock;
	Syncobjs::TCriticalSection* FOnErrorsLock;
	_PROCESS_INFORMATION FProcessInfo;
	Windows::_STARTUPINFOA FStartupInfo;
	Pipeutil::TPipe* FInPipe;
	Pipeutil::TPipe* FOutPipe;
	Pipeutil::TPipe* FErrorPipe;
	int FLastOut;
	int FLastErr;
	bool FTerminated;
	
protected:
	HIDESBASE void __fastcall Startup(Windows::_STARTUPINFOA &StartupInfo, _PROCESS_INFORMATION &ProcessInfo)/* overload */;
	virtual void __fastcall SetExeFileName(AnsiString Value);
	virtual void __fastcall SetCommandLine(AnsiString Value);
	virtual void __fastcall SetWorkingDir(AnsiString Value);
	virtual Classes::TStrings* __fastcall GetOutput(void);
	virtual void __fastcall SetOutput(Classes::TStrings* Value);
	virtual Classes::TStrings* __fastcall GetErrors(void);
	virtual void __fastcall SetErrors(Classes::TStrings* Value);
	void __fastcall SetOnTerminate(Classes::TNotifyEvent Value);
	virtual void __fastcall SetOnOutputChanged(TListChanged Value);
	virtual void __fastcall SetOnErrorChanged(TListChanged Value);
	unsigned __fastcall GetProcess(void);
	unsigned __fastcall GetProcessId(void);
	void __fastcall SetWatch(bool Value);
	void __fastcall DoTerminate(void);
	void __fastcall DoOutputChanged(void);
	void __fastcall DoErrorChanged(void);
	
public:
	__fastcall TMonitorProcess(void)/* overload */;
	__fastcall virtual ~TMonitorProcess(void);
	virtual bool __fastcall CancelProcess(void);
	virtual void __fastcall Run(void);
	bool __fastcall IsRunning(void)/* overload */;
	__property Classes::TNotifyEvent OnTerminate = {read=FOnTerminate, write=SetOnTerminate};
	__property unsigned Process = {read=GetProcess, nodefault};
	__property unsigned ProcessID = {read=GetProcessId, nodefault};
	__property bool Watch = {read=FWatch, write=SetWatch, nodefault};
};


class DELPHICLASS TMonitorProcessException;
class PASCALIMPLEMENTATION TMonitorProcessException : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall TMonitorProcessException(const AnsiString Msg) : Sysutils::Exception(Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall TMonitorProcessException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall TMonitorProcessException(int Ident)/* overload */ : Sysutils::Exception(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall TMonitorProcessException(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall TMonitorProcessException(const AnsiString Msg, int AHelpContext) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall TMonitorProcessException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall TMonitorProcessException(int Ident, int AHelpContext)/* overload */ : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall TMonitorProcessException(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TMonitorProcessException(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const Shortint UserTerminated = 0x64;
extern PACKAGE void __fastcall EnumProcesses(TEnumProcessesEvent EnumProc);

}	/* namespace Processutil */
using namespace Processutil;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Processutil
